﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Text;
using System.Windows.Forms;

namespace SID_monitor
{
	public partial class PanelLocation : UserControl
	{

		public PanelLocation()
		{
			InitializeComponent();

            this.numericUpDownLatDegs.Value = SID_monitor.Properties.Settings.Default.LatDeg;
            this.numericUpDownLatMins.Value = SID_monitor.Properties.Settings.Default.LatMins;
            this.numericUpDownLatSecs.Value = SID_monitor.Properties.Settings.Default.LatSecs;
            this.comboBoxLat.Text = SID_monitor.Properties.Settings.Default.LatHemi;

            this.numericUpDownLongDegs.Value = SID_monitor.Properties.Settings.Default.LongDeg;
            this.numericUpDownLongMins.Value = SID_monitor.Properties.Settings.Default.LongMins;
            this.numericUpDownLongSecs.Value = SID_monitor.Properties.Settings.Default.LongSecs;
            this.comboBoxLong.Text = SID_monitor.Properties.Settings.Default.LongHemi;

        }

        #region Properties
        public Decimal Latitude {
			get
			{
				Decimal latitude_value = this.numericUpDownLatDegs.Value + this.numericUpDownLatMins.Value / 60 + this.numericUpDownLatSecs.Value / 3600;
				if (this.comboBoxLat.Text == "S")
				{
					return -latitude_value;
				}
				else
				{
					return latitude_value;
				}
			}
		}

        public Decimal Longitude
        {
            get
            {
                Decimal longitude_value = this.numericUpDownLongDegs.Value + this.numericUpDownLongMins.Value / 60 + this.numericUpDownLongSecs.Value / 3600;
                if (this.comboBoxLong.Text == "W")
                {
                    return -longitude_value;
                }
                else
                {
                    return longitude_value;
                }
            }
        }

        public uint LatDegs
        {
            get
            {
                return (uint)this.numericUpDownLatDegs.Value;
            }
        }

        public uint LatMins
        {
            get
            {
                return (uint)this.numericUpDownLatMins.Value;
            }
        }

        public uint LatSecs
        {
            get
            {
                return (uint)this.numericUpDownLatSecs.Value;
            }
        }

        public string LatHemi
        {
            get
            {
                return this.comboBoxLat.Text;
            }
        }


        public uint LongDegs
        {
            get
            {
                return (uint)this.numericUpDownLongDegs.Value;
            }
        }

        public uint LongMins
        {
            get
            {
                return (uint)this.numericUpDownLongMins.Value;
            }
        }

        public uint LongSecs
        {
            get
            {
                return (uint)this.numericUpDownLongSecs.Value;
            }
        }

        public string LongHemi
        {
            get
            {
                return this.comboBoxLong.Text;
            }
        }
#endregion

        #region ValidData Event
        public event ValidDataEventHandler ValidData;

        protected virtual void OnValidData(validDataEventArgs e)
        {
            if ( ValidData != null )
            {
                // Invokes the delegates. 
                ValidData(this, e);
            }
        }
        #endregion

	}
}
